PROGRAM 22   PACKER  1379 BYTES             !Main Guided Fault Isolation program

!Inputs:    none
!Called by:	none (standalone)
!Calls to:	programs 3, 4, 9, 23, 26, 27, Setup and Stimulus Programs
!Outputs: 	registers C, 8, and 9 for use by program 20

   DPY-PARAMETER PACK PROGRAM#              !Display message
   REGF = 50                                !Set delay parameter
   EXECUTE PROGRAM 9                        !Delay to see display
   REGA = 0                                 !Set global: clear type parameter
0: LABEL 0                                  !
   DPY-DEVICE TO PROBE (1-F,ENTER)          !Ask for device type
   DPY-+____                                !
   EXECUTE PROGRAM 27                       !Display device type
   EXECUTE PROGRAM 4                        !Wait for operator to press key
   REG0 = REGA                              !Save device type
   REGA = 0                                 !Set global: clear type parameter
   IF REGB = 1C GOTO 1                      !Branch: ENTER key was pressed
   IF REGB = 0 GOTO 0                       !Branch: 0 type not allowed
   REGA = REGB                              !Set global: save device type
   IF F >= REGB GOTO 0                      !Branch: 1-F types allowed
   REGA = REG0                              !Illegal type: restore last good one
   DPY-+#                                   !Beep for erroneous entry
   GOTO 0                                   !Branch: loop till ENTER pressed
1: LABEL 1                                  !
   DPY-ENTER DEVICE NUMBER <256 =           !Ask for device number
   DPY-+ \7                                 !Save in reg 7
   IF REG7 > FF GOTO 1                      !Branch: >FF not allowed
2: LABEL 2                                  !
   DPY-ENTER PIN NUMBER <256 = \6           !Ask for pin number1; save in reg 6
   IF REG6 > FF GOTO 2                      !Branch: >FF not allowed
3: LABEL 3                                  !
   DPY-1ST SUSPECT TYPE <0-F,ENTER          !Ask for 1st suspect
   DPY-+>___                                !
   EXECUTE PROGRAM 27                       !Display suspect type
   EXECUTE PROGRAM 4                        !Wait till key pressed
   REGE = REGA                              !Save suspect type in reg E
   REGA = 0                                 !Set global: clear type parameter
   IF REGB = 1C GOTO 4                      !Branch: ENTER pressed
   REGA = REGB                              !Set global: save device type
   IF F >= REGB GOTO 3                      !Branch: 1-F types allowed
   REGA = REGE                              !Illegal type: restore last good one
   DPY-+#                                   !Beep for erroneous entry
   GOTO 3                                   !Branch: loop till ENTER pressed
4: LABEL 4                                  !
   REG3 = 0                                 !Clear 1st suspect #
   IF REGE = 0 GOTO 7                       !Branch: 1st suspect type = 0
   DPY-1ST SUSPECT NUMBER <256 =            !Ask for suspect #
   DPY-+ \3                                 !Save in reg 3
   IF REG3 > FF GOTO 4                      !Branch: >FF not allowed
   REG3 = REGE SHL SHL SHL SHL SHL SHL      !Merge suspect type with # in reg 3
SHL SHL OR REG3                             !
5: LABEL 5                                  !
   IF REG3 = 0 GOTO 7                       !Branch: no 1st suspect
   DPY-2ND SUSPECT TYPE <0-F,ENTER          !Ask for 2nd suspect type
   DPY-+>____                               !
   EXECUTE PROGRAM 27                       !Display 2nd suspect type
   EXECUTE PROGRAM 4                        !Wait for operator to press key
   REGF = REGA                              !Save suspect type in reg F
   REGA = 0                                 !Set global: clear type parameter
   IF REGB = 1C GOTO 6                      !Branch: ENTER pressed
   REGA = REGB                              !Set global: save device type
   IF F >= REGB GOTO 5                      !Branch: 1-F types allowed
   REGA = REGF                              !Illegal type: restore last good one
   DPY-+#                                   !Beep for erroneous entry
   GOTO 5                                   !Branch: loop till ENTER pressed
6: LABEL 6                                  !
   REG2 = 0                                 !Clear 2nd suspect #
   IF REGF = 0 GOTO 7                       !Branch: no 2nd suspect type
   DPY-2ND SUSPECT NUMBER <256 =            !Ask for 2nd suspect #
   DPY-+ \2                                 !Save in reg 2
   IF REG2 > FF GOTO 6                      !Branch: >FF not allowed
   REG2 = REGF SHL SHL SHL SHL SHL SHL      !Merge suspect type with # in reg 2
SHL SHL OR REG2                             !
7: LABEL 7                                  !
   DPY-PRESS 0=SIG, 1=LEVEL,                !Ask for sig/level/count mode
   DPY-+ 2 = COUNT                          !
   EXECUTE PROGRAM 4                        !Wait for operator to press key
   REG5 = REGB                              !Save key in reg 5
   IF REG5 > 2 GOTO 7                       !Branch: >2 not allowed
8: LABEL 8                                  !
   DPY-PRESS 0=FREE 1=ADRS 2=DATA           !Ask for sync mode
   DPY-+ SYNC                               !
   EXECUTE PROGRAM 4                        !Wait for operator to press key
   REG4 = REGB                              !Save key in reg 4
   IF REG4 > 2 GOTO 8                       !Branch: >2 not allowed
   IF REG4 > 0 GOTO 9                       !Branch: A or D sync selected
   IF REG5 > 0 GOTO 9                       !Branch: not sig and free-run
   DPY-#NO FREE-RUN SIGNATURES              !Display error message
   REGF = 40                                !Set delay parameter
   EXECUTE PROGRAM 9                        !Delay to see display
   GOTO 7                                   !Loop for re-entry of mode & sync
9: LABEL 9                                  !
   REG1 = 0                                 !Clear setup program number
   REGA = 0                                 !Clear stimulus program number
   DPY-SETUP PGM= \A; STIMULUS PGM          !Ask for setup/stimulus pgm #s (dec)
   DPY-+ =\1                                !Save in reg A and 1
   IF REG1 > 63 GOTO 9                      !Branch: >99 decimal not allowed
   IF REGA > 63 GOTO 9                      !Branch: >99 decimal not allowed
   REG1 = REGA SHL SHL SHL SHL SHL SHL      !Merge pgm #s together in reg 1
   SHL SHL OR REG1                          !
   REG8 = REG7 SHL SHL SHL SHL SHL SHL      !Merge probe chip & pin # to reg 8
   SHL SHL OR REG6                          !
   REG9 = REG2 SHL SHL SHL SHL SHL SHL      !Merge 1st and 2nd suspects to reg9
   SHL SHL SHL SHL SHL SHL OR REG3          !
   REG9 = REG9 SHL SHL SHL SHL OR REG0      !Merge probe device type to reg 9
   REG9 = REG9 SHL SHL OR REG4              !Merge sync type to reg 9
   REG9 = REG9 SHL SHL OR REG5              !Merge sig/level/count type to reg 9
   EXECUTE PROGRAM 3                        !Enable key interrupt
   REG4 = 7F                                !Set min count to max
   REG5 = 0                                 !Set max count to min
   IF REGA = 0 GOTO A                       !Branch: no setup progream
   EXECUTE PROGRAM REGA                     !Execute setup program
A: LABEL A                                  !Loop to get known good result
   IF REG8 = 1D GOTO 7                      !Branch: restart if CLEAR pressed
   IF 40 > REG8 GOTO C                      !Branch: loop if no key pressed
   DPY-____                                 !Clear display
   REGA = REG0                              !Set global: device type to probe
   EXECUTE PROGRAM 27                       !Display type to probe
   DPY-+@7-@6                               !Display device number and pin
   REGA = FFFFF                             !Set global: no expected result
   EXECUTE PROGRAM 26                       !Display sig/level/count type
   REGC = REG1                              !Set global: setup/stimulus pgm #s
   EXECUTE PROGRAM 23                       !Stimulate, take, display reading
   DPY-+ CONT                               !Prompt to press CONT when done
   REGF = 50                                !Set delay parameter
   EXECUTE PROGRAM 9                        !Delay to see reading
   IF 2 > REG9 AND 3 GOTO A                 !Branch: not event count
   IF REG5 > REGA GOTO B                    !Branch: old max > new count
   REG5 = REGA                              !Save new max count
B: LABEL B                                  !Old max > new count
   IF REGA > REG4 GOTO A                    !Branch: new count > min count
   REG4 = REGA                              !Save new min count
   GOTO A                                   !Branch: do next reading
C: LABEL C                                  !Routine to enter knwon-good result
   IF REG9 AND 3 = 2 GOTO E                 !Branch: event count mode
   REGD = REGA                              !Set global: save reading
   REG7 = 0                                 !Clear min count
   REG6 = REGD AND FFFF                     !Get signature
   IF REG9 AND 3 = 0 GOTO D                 !Branch: signature mode
   REG6 = REGD SHR SHR SHR SHR SHR SHR      !Get logic level history
   SHR SHR SHR SHR SHR SHR SHR SHR SHR SHR  !
   SHR SHR SHR SHR SHR SHR SHR SHR AND 7    !
   DPY-ENTER LVL (4,2,1=L,X,H) $6           !Ask for history bit pattern
   DPY-+ = \6                               !Save in reg 6
   IF REG6 > 7 GOTO C                       !Branch: >7 not allowed
   REG6 = REG6 SHL SHL SHL SHL SHL SHL      !Move history for later merging
   SHL SHL                                  !
   GOTO F                                   !
D: LABEL D                                  !Routine to enter known good history
   DPY-ENTER SIGNATURE $6 = \6              !Ask for good sig; save in reg 6 
   IF REG6 > FFFF GOTO D                    !Branch: >FFFF not allowed
   GOTO F                                   !Exit
E: LABEL E                                  !Routine to enter min and max count
   REG6 = REG4                              !Get min count read
   REG7 = REG5                              !Get max count read
   DPY-ENTER COUNT MIN @6=\6                !Ask for min count; save in reg 6
   DPY-, MAX @7=\7                          !Ask for max count; save in reg 7
   IF REG6 > 7F GOTO E                      !Branch: >7F min not allowed
   IF REG7 > 7F GOTO E                      !Branch: >7F max not allowed
   REG6 = REG6 SHL SHL SHL SHL SHL SHL      !Move counts for later merging
   SHL SHL                                  !
F: LABEL F                                  !Display parameters and loop
   REG8 = REG6 SHL SHL SHL SHL SHL SHL      !Merge sig, hist, max cnt into reg 8
SHL SHL SHL SHL SHL SHL SHL SHL SHL SHL     !
OR REG8                                     !
   REG8 = REG7 SHL SHL SHL SHL SHL SHL      !Merge known-good min count to reg 8
SHL SHL SHL SHL SHL SHL SHL SHL SHL SHL     !
OR REG8                                     !
   REGC = REG1                              !Get   setup/stimulus   program   #s
   DPY-REG C=$C; 8=$8; 9=$9                 !Display parametes for program 20
   AUX-REG C=$C;  8=$8;  9=$9               !Send parameters to RS-232 I/F
   EXECUTE PROGRAM 4                        !Wait for operator to press a key
   REGA = 0                                 !Set global: initialize device type
   SYNC FREE-RUN                            !Reset sync mode to free-run
   GOTO 0                                   !Loop to beginning of program
 